<?php 

$page_title="Manage Reports";

include("includes/header.php");
require("includes/function.php");
require("language/language.php");

function get_user_info($user_id)
{
  global $mysqli;

  $user_qry="SELECT * FROM tbl_users WHERE id='".$user_id."'";
  $user_result=mysqli_query($mysqli,$user_qry);
  $user_row=mysqli_fetch_assoc($user_result);

  return $user_row;
}

function get_post_info($post_id,$type)
{ 
  global $mysqli;   

  if($type=='song')
  {
    $qry_data='SELECT * FROM tbl_mp3 WHERE id='.$post_id.'';     
    $data_row = mysqli_fetch_array(mysqli_query($mysqli,$qry_data));
    return $data_row['mp3_title'];
  }
  else
  {
    $qry_data='SELECT * FROM tbl_radio WHERE id='.$post_id.'';     
    $data_row = mysqli_fetch_array(mysqli_query($mysqli,$qry_data));    
    return $data_row['radio_name'];
  }
}
?>


<div class="row">
  <div class="col-md-12">
    <?php
        if(isset($_SERVER['HTTP_REFERER']))
          {
            echo '<a href="'.$_SERVER['HTTP_REFERER'].'"><h4 class="pull-left" style="font-size: 20px;color: #e91e63"><i class="fa fa-arrow-left"></i> Back</h4></a>';
         }
      ?>
    <div class="card">
      <div class="page_title_block">
        <div class="col-md-5 col-xs-12">
          <div class="page_title"><?=$page_title?></div>
        </div>
      </div>

      <div class="clearfix"></div>
      <div class="card-body mrg_bottom" style="padding: 0px">
        <ul class="nav nav-tabs" role="tablist">
          <li role="presentation" class="active"><a href="#radio_report" aria-controls="radio_report" role="tab" data-toggle="tab">Radio Report</a></li>
          <li role="presentation"><a href="#song_report" aria-controls="song_report" role="tab" data-toggle="tab">Songs Report</a></li>
        </ul>

        <div class="tab-content">
          <div role="tabpanel" class="tab-pane active" id="radio_report">
            <div class="section">
              <div class="section-body">
                <div class="col-md-12">
                  <table class="datatable table table-striped table-bordered table-hover">
                    <thead>
                      <tr>
                        <th>Name</th>
                        <th>Radio</th>
                        <th>Report</th>
                        <th>Date</th> 
                        <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>

                      <?php
                      $sql="SELECT * FROM tbl_radio
                      LEFT JOIN tbl_reports ON tbl_radio.`id`=tbl_reports.`post_id`
                      WHERE tbl_reports.`type`='radio' ORDER BY tbl_reports.`id` DESC";

                      $res=mysqli_query($mysqli, $sql);
                      $i=1;
                      while($row=mysqli_fetch_assoc($res))
                        {?>
                          <tr>
                            <td><?php echo get_user_info($row['user_id'])['name'];?></td>
                            <td><?php echo $row['radio_name'];?></td>
                            <td><?=nl2br($row['report'])?></td>
                            <td nowrap=""><?=date('d-m-Y',$row['report_on'])?></td>
                            <td>
                              <a href="javascript:void(0)" data-id="<?php echo $row['id']; ?>" data-table="tbl_reports" data-toggle="tooltip" data-tooltip="Delete" class="btn btn-danger btn_delete_a btn_cust"><i class="fa fa-trash"></i></a>
                            </td>

                          </tr>
                          <?php 
                        }
                        ?>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>

            <div role="tabpanel" class="tab-pane" id="song_report">
              <div class="section">
                <div class="section-body">
                  <div class="col-md-12">
                    <table class="datatable table table-striped table-bordered table-hover">
                      <thead>
                        <tr>
                          <th>Name</th>
                          <th>Song</th>
                          <th>Report</th> 
                          <th>Date</th> 
                          <th>Action</th>
                        </tr>
                      </thead>
                      <tbody>
                       <?php 
                       $sql="SELECT * FROM tbl_mp3
                       LEFT JOIN tbl_reports ON tbl_mp3.`id`=tbl_reports.`post_id`
                       WHERE tbl_reports.`type`='song' ORDER BY tbl_reports.`id` DESC";

                       $res=mysqli_query($mysqli, $sql);
                       $i=1;
                       while($row=mysqli_fetch_assoc($res))
                       {
                        ?>
                        <tr>
                          <td><?php echo get_user_info($row['user_id'])['name'];?></td>
                          <td><?php echo $row['mp3_title'];?></td>
                          <td><?=$row['report']?></td>
                          <td nowrap=""><?=date('d-m-Y',$row['report_on'])?></td>
                          <td>
                            <a href="javascript:void(0)" data-id="<?php echo $row['id'];?>" data-table="tbl_reports" class="btn btn-danger btn_delete_a btn_cust"><i class="fa fa-trash"></i></a>
                          </td>
                        </tr>
                        <?php 
                      }
                      ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

        </div>   

      </div>
    </div>
  </div>
</div>


<?php include("includes/footer.php");?>   

<script type="text/javascript">

  $('a[data-toggle="tab"]').on('show.bs.tab', function(e) {
    localStorage.setItem('activeTab', $(e.target).attr('href'));
  });

  var activeTab = localStorage.getItem('activeTab');
  if(activeTab){
    $('.nav-tabs a[href="' + activeTab + '"]').tab('show');
  }

  $('a[data-toggle="tooltip"]').tooltip({
    animated: 'fade',
    placement: 'bottom',
    html: true
  });

</script>    
